<?php
/**
 * The template for displaying product category thumbnails within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product_cat.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $woocommerce_loop;

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 3 );
}

// Increase loop count
$woocommerce_loop['loop']++;
?>
<li <?php wc_product_cat_class(); ?>>
    <?php do_action( 'woocommerce_before_subcategory', $category ); ?>

    <?php $link = get_term_link( $category->slug, 'product_cat' ); ?>
    <a href="<?php echo ! is_wp_error( $link ) ? $link : ''; ?>"<?php if ( yiw_get_option('shop_show_shadow_categories_page') ) : ?> class="shadow"<?php endif ?>>

        <?php
            /**
             * woocommerce_before_subcategory_title hook
             *
             * @hooked woocommerce_subcategory_thumbnail - 10
             */
            do_action( 'woocommerce_before_subcategory_title', $category );
        ?>

        <h3 class="<?php echo yiw_get_option('shop_title_position_categories_page') ?>">
            <?php echo $category->name; ?>
            <?php if ( $category->count > 0 ) : ?>
                <?php echo apply_filters( 'woocommerce_subcategory_count_html', ' <mark class="count">(' . $category->count . ')</mark>', $category ); ?>
            <?php endif; ?>
        </h3>

        <?php
            /**
             * woocommerce_after_subcategory_title hook
             */
            do_action( 'woocommerce_after_subcategory_title', $category );
        ?>

	</a>

	<?php do_action( 'woocommerce_after_subcategory', $category ); ?>
</li>
