<?php
/**
 * @package WordPress
 * @subpackage YIW Themes
 * 
 * Here the first hentry of theme, when all theme will be loaded.
 * On new update of theme, you can not replace this file.
 * You will write here all your custom functions, they remain after upgrade.
 */                                                                               

// include all framework
require_once dirname(__FILE__) . '/core/core.php';

// include the library for the layers slider
require_once dirname(__FILE__) . '/inc/LayerSlider/layerslider.php';

// include the library for the wishlist
//require_once dirname(__FILE__) . '/inc/yith_wishlist/init.php';

/*-----------------------------------------------------------------------------------*/
/* End Theme Load Functions - You can add custom functions below */
/*-----------------------------------------------------------------------------------*/


function replacePayPalIcon($iconUrl) {
	return get_bloginfo('stylesheet_directory') . '/images/acceptedCards.png';
}
 
add_filter('woocommerce_paypal_icon', 'replacePayPalIcon');


add_filter( 'woocommerce_breadcrumb_defaults', 'jk_change_breadcrumb_home_text' );
function jk_change_breadcrumb_home_text( $defaults ) {
	$defaults['home'] = 'Navigation';
	return $defaults;
}


add_filter( 'woocommerce_breadcrumb_home_url', 'woo_custom_breadrumb_home_url' );
function woo_custom_breadrumb_home_url() {
    return 'http://conquestcarbon.com/shop/';
}

function custom_wc_admin_variations_per_page( $qty ) {
	return 20;
}

add_filter( 'woocommerce_admin_meta_boxes_variations_per_page', 'custom_wc_admin_variations_per_page' );



//Change Backorder text in WooCommerce
// function backorder_text($available) {
// foreach($available as $i) {
// $available = str_replace('Available on backorder', 'Available on back order - Pre-order yours today.', $available);
// }
// return $available;
// }
// add_filter('woocommerce_get_availability', 'backorder_text');


function admin_default_page() {
  return 'http://shop.conquestcarbon.com/';
}

add_filter('login_redirect', 'admin_default_page');